/*
 * Decompiled with CFR 0.152.
 */
package exploit.conversion;

import exploit.conversion.RBase;
import exploit.conversion.RGraph;
import java.util.Vector;

public class RNode {
    private RBase myObject;
    private int myID;
    private boolean active = true;
    private Vector parents;
    private Vector children;
    public RNode parent;
    public RNode child;
    public boolean flag;
    public RGraph myGraph;

    public RNode(RBase rBase, int n, RGraph rGraph) {
        this.myObject = rBase;
        this.parents = new Vector();
        this.children = new Vector();
        this.parent = null;
        this.child = null;
        this.flag = false;
        this.myID = n;
        this.myGraph = rGraph;
    }

    public RGraph getGraph() {
        return this.myGraph;
    }

    public void lockdown() {
        this.active = false;
    }

    public boolean isAlive() {
        return this.active;
    }

    public int getID() {
        return this.myID;
    }

    public RBase getObject() {
        return this.myObject;
    }

    public void reset() {
        this.parents.clear();
        this.children.clear();
        this.parent = null;
        this.child = null;
    }

    public void clean() {
        this.parent = null;
        this.child = null;
    }

    public void wipe() {
        RNode rNode;
        int n;
        for (n = 0; n < this.getChildCount(); ++n) {
            rNode = this.getChild(n);
            rNode.removeParent(this);
        }
        for (n = 0; n < this.getParentCount(); ++n) {
            rNode = this.getParent(n);
            rNode.removeChild(this);
        }
        this.parents.clear();
        this.children.clear();
        this.active = false;
    }

    public boolean isNormal() {
        return this.getChildCount() <= 1 && this.getParentCount() <= 1;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getParentCount() {
        return this.parents.size();
    }

    public RNode getChild(int n) {
        if (n < this.getChildCount() && n >= 0) {
            return (RNode)this.children.get(n);
        }
        return null;
    }

    public RNode getParent(int n) {
        if (n < this.getParentCount() && n >= 0) {
            return (RNode)this.parents.get(n);
        }
        return null;
    }

    public void removeParent(RNode rNode) {
        this.parents.remove(rNode);
    }

    public void removeChild(RNode rNode) {
        this.children.remove(rNode);
    }

    public boolean hasChild(int n) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChild(i).getID() != n) continue;
            return true;
        }
        return false;
    }

    public void addChild(RNode rNode) {
        this.children.add(rNode);
    }

    public void addParent(RNode rNode) {
        this.parents.add(rNode);
    }
}

